/*
 * JUnit test case
 * 
 * This test case is primarily used to test the result returned from the
 * fatPercentage() function in the Calories class.  
 */

import junit.framework.TestCase;

/*
 * JUnit test case for Calories class
 */
public class JUnitTest extends TestCase {

	/*
	 * JUnit constructor
	 */
	public JUnitTest(String name) {
		super(name);
	}

	/*
	 * Grams of fat are much higher than total calories.  This would produce a
	 * result larger than 100.0%, and shouldn't be possible.
	 */
	public void testFatPercentage1() {
		int fat = 343;
		int cal = 4;
		try {
			assertTrue(
				Calories.fatPercentage(fat, cal) >= 0 &&
				Calories.fatPercentage(fat, cal) <= 100
			);
		} catch (Exception e) {}
	}
	
	/*
	 *  If something has no fat, the fat percentage should be 0
	 */
	public void testFatPercentage2() {
		try {
			assertTrue(Calories.fatPercentage(0, 200) == 0);
		} catch (Exception e) {}
	}
	
	/*
	 *  Negative values shouldn't produce a real result
	 */
	public void testFatPercentage3() {
		try {
			assertTrue(Calories.fatPercentage(0, -100) == 0);
		} catch (Exception e) {}
	}
	
	/*
	 *  Negative values shouldn't produce a real result
	 */
	public void testFatPercentage4() {
		try {
			assertTrue(Calories.fatPercentage(-1, -100) == 0);
		} catch (Exception e) {}
	}

	/*
	 * Negative values shouldn't produce real results
	 */
	public void testFatPercentage5() {
		try {
			assertTrue(Calories.fatPercentage(-10, 3) == 0);
		} catch (Exception e) {}
	}
}
